
' MwStack.ini
' Autor: Michael Wodrich
' Public Domain

' Verwaltet einen Bereich wie einen Stapel
' (fr LongInt-Werte).
'
' Der vorher dimensionierte Bereich wird
' als Adresse bergeben.
'
' Auf diese Art kann die Klasse "LStack"
' beliebig viele Stapel verwalten.
'
' SP zeigt bei 'diesem' Stapel immer auf den
' obersten besetzten Platz oder enthlt den Wert "-1".
' Der gltige Bereich von SP reicht also von 0 bis Size-1

Class LStack = #lsSize&,#lsSP&,#lsAdr&, \
               #getSz@, #setSz@, \
               #getSP@, #setSP@, \
               #getA@, #setA@, \
               Calc@, \
               Init@, Exit@, \
               Size@, SP@, Clear@, \
               Push@, Pop@, \
               Poke@, Peek@, PeekTop@

Declare TRUE&,FALSE&
TRUE& = 1
FALSE& = 0


' setzen/lesen der Gre
Proc LStack.getSz
  Return .lsSize&
EndProc
Proc LStack.setSz
  Parameters Sz&
  .lsSize& = Sz&
  Return TRUE&
EndProc

' setzen/lesen des Stapelzeigers
Proc LStack.getSP
  Return .lsSP&
EndProc
Proc LStack.setSP
  Parameters SP&
  .lsSP& = SP&
  Return TRUE&
EndProc

' setzen/lesen der Stapeladresse
Proc LStack.getA
  Return .lsAdr&
EndProc
Proc LStack.setA
  Parameters A&
  .lsAdr& = A&
  Return TRUE&
EndProc


' .Calc( MaxAnz& )
'   Liefert die Gre des
'   zu dimensionierenden Bereiches zurck
Proc LStack.Calc
  Parameters Max_Elemente&
  Return (Max_Elemente& * 4)
EndProc


' .Clear
'   Entfernt alle Elemente vom Stapel.
'   (setzt einfach nur den Stapelzeiger herunter)
Proc LStack.Clear
  .setSP( -1 )
  Return TRUE&
EndProc


' .Init( MaxAnz&, Adr& )
'   Initialisiert die Variablen.
'   Der Stapel kann bis zu "MaxAnz" Eintrge aufnehmen.
'   "Adr" ist die Adresse eines Bereiches, der
'   gro genug dimensioniert sein mu (siehe: .Calc)
Proc LStack.Init
  Parameters MaxAnz&, Adr&
  .setA( Adr& )
  .setSz( MaxAnz& )
  .Clear()
  Return TRUE&
EndProc


' .Exit()
'   Gebe den Speicher fr den Stapel wieder frei.
'   In diesem Fall nicht erforderlich, aber wenn
'   eine eigene Speicherverwaltung geerbt wird...
Proc LStack.Exit
  Return TRUE&
EndProc


' .Size()
'   Liefert die Gre des Stapels zurck.
'   (max. Anzahl der mglichen Werte auf dem Stapel)
Proc LStack.Size
  Return .getSz()
EndProc


' .Push( Wert& )
'   Speichert "Wert" auf dem Stapel.
'   Liefert TRUE bei Erfolg, FALSE bei vollem Stapel.
Proc LStack.Push
  Parameters Wert&
  Declare ok&, SP&,Adr&
  SP& = .getSP() + 1
  If SP& < .getSz()
    ok& = TRUE&
    Adr& = .getA()
    Long Adr&,(SP& << 2) = Wert&
    .setSP( SP& )
  Else
    ' Stapel ist voll, Wert wird nicht gespeichert
    Clear ok&  'FALSE
  EndIf
  Return ok&
EndProc


' .Pop()
'   Liefert und entfernt den obersten Wert vom Stapel.
'   Wenn der Stapel leer ist, wird Null zurckgegeben.
'   Stapelprfung:
'      CASE Stapel.SP() = -1 : Print "Oh, leer!"
Proc LStack.Pop
  Declare Wert&, SP&,Adr&
  SP& = .getSP()
  If SP& >= 0
    Adr& = .getA()
    Wert& = Long( Adr&, (SP& << 2) )
    .setSP( SP& - 1 )
  Else
    ' Nichts mehr auf dem Stapel, liefert Null
    Clear Wert&
  EndIf
  Return Wert&
EndProc


' .SP
'   Liefert den Stapelzeiger zurck.
Proc LStack.SP
  Return .getSP()
EndProc


' .Peek( Index& )
'   Liefert den Wert, der an Position "Index"
'   gespeichert ist.
'   Der Wert im Stapel bleibt erhalten.
'   Der Stapelzeiger wird ignoriert!
'   Es knnen alle Werte im Stapel,
'   gltig oder auch nicht, gelesen werden.
Proc LStack.Peek
  Parameters Index&
  Declare Wert&
  If (Index& < 0) or (Index& >= .getSz())
    ' Der Index liegt nicht in den Grenzen des Stapels
    Clear Wert&   'liefert Null
  Else
    Wert& = Long( .getA(), (Index& << 2) )
  EndIf
  Return Wert&
EndProc


' .PeekTop()
'   Liefert den obersten Wert vom Stapel.
'   Der Wert im Stapel bleibt erhalten.
Proc LStack.PeekTop
  Declare Wert&, SP&
  SP& = .getSP()
  If SP& >= 0
    Wert& = Long( .getA(), (SP& << 2) )
  Else
    ' Der Stapel ist leer. Liefert Null.
    Clear Wert&
  EndIf
  Return Wert&
EndProc


' .Poke( Index&, Wert& )
'   Setzt einen Wert an beliebiger Position des Stapels.
'   Der Stapelzeiger wird nicht verndert,
'   sein Wert wird ignoriert!
'   Der Wert kann an alle Positionen des
'   gltigen Stapelbereiches geschrieben werden,
'   auch wenn SP diesen Wert nicht "erreicht".
Proc LStack.Poke
  Parameters Index&, Wert&
  Declare Adr&
  If (Index& >= 0) and (Index& < .getSz())
    Adr& = .getA()
    Long Adr&,(Index& << 2) = Wert&
  EndIf
  Return TRUE&
EndProc



