
' -------------------------------------------------------
' FindWin.inc
' umgeschrieben - die Ergebnisse sind jetzt nicht mehr
'   das Fensterhandle, sondern der vollstndige Titel.
' Das ist universeller zu verwenden.
' -------------------------------------------------------


' In diesen Variablen werden Daten gehalten, damit Find...Next 
' einfacher ablaeuft.
'   LastI% - letzte Fundstelle
'   LastS$ - der Suchstring
Declare LastI%, LastS$

' -------------------------------------------------------

' Alle Fenstertitel in die ListBox-Liste und dann
' die rechte Seite der Titel nach dem Suchwert absuchen.
'   Liefert Handle des ersten Treffers oder Null.
'
Proc FindWinRightFirst
  Parameters Such$
  Declare Anz%, Laenge%, Erg$, Ok%
  Clear LastI%, Erg$, Ok%
  LastS$ = @Upper$(Such$)
  Laenge% = @Len(LastS$)
  ClearList
  AddWindows ""
  Anz% = %GetCount
  While LastI% < Anz%
    Erg$ = @ListBoxItem$(LastI%)
    Case (Right$(@Upper$(Erg$),Laenge%) = LastS$) : Inc Ok%
    Case Ok% : BREAK
    Inc LastI%
  EndIf
  CaseNot Ok% : Erg$ = ""
  Return Erg$
EndProc


' Setzt die Suche in der ListBox-Liste fort.
' Erwartet Einstellungen, die in "FindWinRightFirst" vorgenommen werden.
'   Liefert Handle des naechsten Treffers oder Null.
'
Proc FindWinRightNext
  Declare Anz%, Laenge%, Erg$, Ok%
  Clear Erg$, Ok%
  Inc LastI%
  Laenge% = @Len(LastS$)
  Anz% = %GetCount
  While LastI% < Anz%
    Erg$ = @ListBoxItem$(LastI%)
    Case (Right$(@Upper$(Erg$),Laenge%) = LastS$) : Inc Ok%
    Case Ok% : BREAK
    Inc LastI%
  EndWhile
  CaseNot Ok% : Erg$ = ""
  Return Erg$
EndProc

' -------------------------------------------------------

' Alle Fenstertitel in die ListBox-Liste und dann
' den gesamten Titel nach dem Suchwert absuchen.
'   Liefert Handle des ersten Treffers oder Null.
'
Proc FindWinFirst
  Parameters Such$
  Declare Anz%, Erg$, Ok%
  Clear LastI%, Erg$, Ok%
  LastS$ = @Upper$(Such$)
  ClearList
  AddWindows ""
  Anz% = %GetCount
  While LastI% < Anz%
    Erg$ = @ListBoxItem$(LastI%)
    Case @InStr(LastS$,@Upper$(Erg$)) : Inc Ok%
    Case Ok% : BREAK
    Inc LastI%
  EndIf
  CaseNot Ok% : Erg$ = ""
  Return Erg$
EndProc


' Setzt die Suche in der ListBox-Liste fort.
' Erwartet Einstellungen, die in "FindWinFirst" vorgenommen werden.
'   Liefert Handle des naechsten Treffers oder Null.
'
Proc FindWinNext
  Declare Anz%, Erg$, Ok%
  Clear Erg$, Ok%
  Inc LastI%
  Anz% = %GetCount
  While LastI% < Anz%
    Erg$ = @ListBoxItem$(LastI%)
    Case @InStr(LastS$,@Upper$(Erg$)) : Inc Ok%
    Case Ok% : BREAK
    Inc LastI%
  EndWhile
  CaseNot Ok% : Erg$ = ""
  Return Erg$
EndProc

' -------------------------------------------------------

Rem ' Main
Rem Declare hE&, Titel$
Rem Titel$ = @FindWinRightFirst("Microsoft Outlook")
Rem While Titel$ <> 0
Rem   hE& = @FindWindow(Titel$)
Rem   Case hE& : @SendMessage(hE&,$0010,0,0)
Rem   Titel$ = @FindWinRightNext()
Rem EndIf

Rem ' ...oder

Rem ' Main
Rem Declare hE&, Titel$
Rem Titel$ = @FindWinFirst("Notepad")
Rem While Titel$ <> ""
Rem   hE& = @FindWindow(Titel$)
Rem   Case hE& : @SendMessage(hE&,$0010,0,0)
Rem   Titel$ = @FindWinNext()
Rem EndIf

